<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-26 15:04
 */
interface RestaurantkitchenprintDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantkitchenprint 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantkitchenprint primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantkitchenprint restaurantkitchenprint
 	 */
	public function insert($restaurantkitchenprint);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantkitchenprint restaurantkitchenprint
 	 */
	public function update($restaurantkitchenprint);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrderId($value);

	public function queryByProductId($value);

	public function queryByQuantity($value);

	public function queryByTogetherNo($value);

	public function queryByIsPrinted($value);


	public function deleteByOrderId($value);

	public function deleteByProductId($value);

	public function deleteByQuantity($value);

	public function deleteByTogetherNo($value);

	public function deleteByIsPrinted($value);


}
?>